<?php
/*
Author: GeoDirectory
URL: http://wpgeodirectory.com/
*/
if (!defined('GDF_VERSION')) define('GDF_VERSION', '2.0.0.6');
if (!defined('GDF_DIR')) define('GDF_DIR', dirname(__FILE__));
if (!defined('GEODIRECTORY_FRAMEWORK')) define('GEODIRECTORY_FRAMEWORK', 'geodirectory_framework');


include_once("includes/class-gdf-core.php"); // init the core class


/**
 * Show WP Easy Updates required admin notification.
 */
if(is_admin()){
	if (!function_exists('ayecode_show_update_plugin_requirement')) {//only load the update file if needed
		function ayecode_show_update_plugin_requirement() {
			if ( !defined( 'WP_EASY_UPDATES_ACTIVE' ) ) {
				?>
				<div class="notice notice-warning is-dismissible">
					<p>
						<strong>
							<?php
							echo sprintf( __( 'The plugin %sWP Easy Updates%s is required to check for and update some installed plugins/themes, please install it now.', 'geodirectory' ), '<a href="https://wpeasyupdates.com/" target="_blank" title="WP Easy Updates">', '</a>' );
							?>
						</strong>
					</p>
				</div>
				<?php
			}
		}

		add_action( 'admin_notices', 'ayecode_show_update_plugin_requirement' );
	}
}